<?php
// Include database connection and configuration
include 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

// Retrieve JSON data from request body
$data = json_decode(file_get_contents('php://input'), true);
$conn = connectToDatabase();

// Validate and process incoming data
if (isset($data['auth_code'])) {
    $auth_code = $data['auth_code'];

    // Prepare SQL statement to retrieve user and profile details based on auth_code
       $sql = "SELECT u.id, u.username,u.password, u.status, u.auth_code, 
                  
                   JSON_OBJECT(
                          'profile_id', p.profile_id, 
                          'profile_name', p.profile_name, 
                          'server', p.vpn_server, 
                          'username', p.vpn_username, 
                          'password', p.vpn_password, 
                          'port', p.port, 
                          'launch_url', p.launch_url) AS vpn
            FROM users u
            LEFT JOIN profile p ON u.profile_id = p.profile_id
            WHERE u.auth_code = :auth_code";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':auth_code', $auth_code);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
         $vpn = ($result['vpn']) ? json_decode($result['vpn'], true) : null;

    $response = [
        'success' => true,
        'data' => [
            'id' => $result['id'],
            'username' => $result['username'],
            'password' => $result['password'],
            'status' => $result['status'],
            'auth_code' => $result['auth_code'],
            'vpn' => $vpn
        ]
    ];
    echo json_encode($response);
        // Return user and profile details
     //   echo json_encode(['success' => true, 'data' => $user]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid auth code']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Missing auth code']);
}

$conn = null;
?>
